package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@SuppressWarnings("rawtypes")
@Entity
@Table(name="datasourcedisplayheader", schema="hib")
public class DataSourceDisplayHeader extends ReferenceObject implements Comparable {

	@Column(name="headid")
	protected int headId;

	@Column(name="sortorder")
	protected int sortOrder;

	@Column(name="requesttypeid")
	protected int requestTypeId;
	
	
//	@ManyToMany(fetch=FetchType.LAZY)
//	@JoinTable(
//		      name="datasourcedisplay", schema="hib",
//		      joinColumns={@JoinColumn(name="datasourceheaderid", referencedColumnName="ID")},
//		      inverseJoinColumns={@JoinColumn(name="datasourceid", referencedColumnName="ID")})
//	Set<DataSource> dataSources;
	
	
	
	public int getHeadId() {
		return headId;
	}

	public void setHeadId(int headId) {
		this.headId = headId;
	}

	public int getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(int sortOrder) {
		this.sortOrder = sortOrder;
	}

	public int getRequestTypeId() {
		return requestTypeId;
	}

	public void setRequestTypeId(int requestTypeId) {
		this.requestTypeId = requestTypeId;
	}
	
	
//	public Set<DataSource> getDataSources() {
//		return dataSources;
//	}


	
	public static DataSourceDisplayHeader findById(final int dataSourceHeaderId) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getDataSourceDisplayHeaderDAO().findById(dataSourceHeaderId);
	}

	public static List<DataSourceDisplayHeader> listAll() {
		return DartObjectFactory.getInstance().getDataSourceDisplayHeaderDAO().listAll();
	}

	public static List<DataSourceDisplayHeader> listAllByRequestType(final int requestTypeId) {
		return DartObjectFactory.getInstance().getDataSourceDisplayHeaderDAO().listAllByRequestType(requestTypeId);
	}
	
//	public static List<DataSource> listDataSourcesByHeaderId(int dataSourceHeaderId) throws ObjectNotFoundException {
//		return DartObjectFactory.getInstance().getDataSourceDisplayHeaderDAO().listDataSourcesByHeaderId(dataSourceHeaderId);
//	}
	
	
	@Override 
	public boolean equals(Object obj) {
		if( obj == null ) {
			return false;
		}

		if ((obj instanceof DataSourceDisplayHeader) == false) {
			return false;
		}

		return this.getId() == ((DataSourceDisplayHeader)obj).getId();	//compare the id
	}

	@Override
	public int compareTo(Object o) {
		if (o == null) {
			return -1;
		}
		if ((o instanceof DataSourceDisplayHeader) == false) {
			return -1;
		}
		
		DataSourceDisplayHeader obj2 = (DataSourceDisplayHeader)o;

		// sort by sortOrder
		if (this.getSortOrder() == obj2.getSortOrder()) {
			return 0;
		}
		
		return this.getSortOrder() < obj2.getSortOrder() ? -1 : 1;
	}
	
}
